#define IDPerangkat         "semesin 001"
#define debugSerial         1
#define panjangString       17

#include <BluetoothApk.h>
#include "alat.h"

//#include "BluetoothSerial.h"
//BluetoothSerial bt;

#include "SoftwareSerial.h"
SoftwareSerial bt;

BluetoothApk bluetoothApk(&bt);

char idPengguna[] = "semesin";
char kataSandi[] = "1234";

bool aksesApk;

struct Setting
{
  char idPengguna[panjangString];
  char kataSandi[panjangString];
};

Setting setting;


enum PerintahBluetooth
{
  tidakAda,//0
  inisialisasi,//1
  aksesMasuk,//2
  aksesKeluar,//3
  gantiKataKunci,//4
  settingPabrik,//5
  masukModeEntri,//6
  keluarModeEntri,//7
  ambilData,//8
  simpanData,//9
};


void setup() {
  Serial.begin(115200);
  bt.begin("bluetoothAPK");

  copy(idPengguna, setting.idPengguna);
  copy(kataSandi, setting.kataSandi);
}

void loop() {
  cekBluetooth();
}

void cekBluetooth()
{
  byte buffer[panjangString * 3];
  if (bluetoothApk.cekTransmisi())
  {
    switch (bluetoothApk.data.perintah)
    {
      case inisialisasi:
        bluetoothApk.perintahDiterima();
        debugln(F("inisialisasi"));
        break;

      case aksesMasuk:
        bluetoothApk.ambilBuffer(buffer, sizeof(buffer));
        if (
          (compare(setting.idPengguna, buffer)) &&
          (compare(setting.kataSandi, buffer + panjangString))
        )
        {
          aksesApk = true;
          bluetoothApk.responData(&bluetoothApk.responOK, 1);
        }
        else
        {
          bluetoothApk.responData(&bluetoothApk.responNull, 1);
        }
        debugln(F("aksesMasuk"));
        break;
    }
    if (aksesApk)
    {
      switch (bluetoothApk.data.perintah)
      {
        case aksesKeluar:
          bluetoothApk.perintahDiterima();
          aksesApk = false;
          debugln(F("aksesKeluar"));
          break;
        case gantiKataKunci:
          bluetoothApk.ambilBuffer(buffer, sizeof(buffer));
          if (
            (compare(setting.kataSandi, buffer)) &&
            (compare(buffer + panjangString, buffer + (2 * panjangString)))
          )
          {
            copy(buffer + panjangString, setting.kataSandi);
            bluetoothApk.responData(&bluetoothApk.responOK, 1);
          }
          else
          {
            bluetoothApk.responData(&bluetoothApk.responNull, 1);
          }
          debugln(F("gantiKataKunci"));
          break;
        case settingPabrik:
          debugln(F("settingPabrik"));
          break;
        case masukModeEntri:
          debugln(F("masukModeEntri"));
          break;
        case keluarModeEntri:
          debugln(F("keluarModeEntri"));
          break;
        case ambilData:
          debugln(F("ambilData"));
          break;
        case simpanData:
          debugln(F("simpanData"));
          break;
      }
    }
  }
}
void debugln(const __FlashStringHelper * str)
{
#if debugSerial
  Serial.println(str);
#endif
}
void debug(const __FlashStringHelper * str)
{
#if debugSerial
  Serial.print(str);
#endif
}


